'********************************************************************************
' Copyright  MigrationWiz 2011.  All rights reserved.
' Description: Compares the UPN to Email Address
'********************************************************************************

dim filename
filename = "Check-Exchange2003UserPrincipalNameAndEmailAddress.txt"

'********************************************************************************
' Helper Functions
'********************************************************************************

function RetrieveUsers()

    dim rootDse, defaultNamingContext, ldapQuery, ldap, conn, rs

    set rootDse = GetObject("LDAP://RootDSE")
    defaultNamingContext = rootDse.Get("defaultNamingContext")
    ldapQuery = "(&(objectCategory=person)(objectClass=user)(mail=*))"
    ldap = "<LDAP://" & defaultNamingContext & ">;" & ldapQuery & ";adspath;subtree"

    set conn = CreateObject("ADODB.Connection")
    conn.Provider = "ADsDSOObject"    
    conn.Open "Active Directory Provider"
    set RetrieveUsers = conn.Execute(ldap)

end function

'********************************************************************************
' Main Executor
'********************************************************************************

function Main()

    dim fso, dump, users, user

    set fso = CreateObject("Scripting.FileSystemObject")
    set dump = fso.CreateTextFile(filename)
    if not err.number = vbEmpty then
        msgbox err.message, 0, "Compare-Exchange2003UserPrincipalNameAndEmailAddress"
        exit function
    end If

    set users = RetrieveUsers()
    while not users.EOF
        set user = GetObject(users.Fields(0).Value)

        if not user.Get("userPrincipalName") = user.Get("mail") then
            dump.Write("LDAP  = ")
            dump.WriteLine(user.AdsPath)
            dump.Write("UPN   = ")
            dump.WriteLine(user.Get("userPrincipalName"))
            dump.Write("Email = ")
            dump.WriteLine(user.Get("mail"))
            dump.WriteLine("")
        end if
       
        users.MoveNext
    wend

    msgbox "UPNs compared to their email address", 0, "Compare-Exchange2003UserPrincipalNameAndEmailAddress"

end function

Main
