'********************************************************************************
' Copyright  MigrationWiz 2011.  All rights reserved.
' Description: Creates Exchange contacts for mail forwarding
'********************************************************************************

dim contactsOuName, forwardingDomain

forwardingDomain = "example.onmicrosoft.com"
contactsOuName = "External Forwards"

'********************************************************************************
' Helper Functions
'********************************************************************************

function BuildContactsOuDn(name)

    dim rootDse, defaultNamingContext
    
    set rootDse = GetObject("LDAP://RootDSE")
    defaultNamingContext = rootDse.Get("defaultNamingContext")
    
    BuildContactsOuDn = "OU=" & name & "," & defaultNamingContext

end function

function CreateOu(dn)

    dim parent, parentDn, ou, cn, sections
    sections = Split(dn, ",", 2)
    cn = sections(0)
    parentDn = sections(1)
    
    on error resume next
    set ou = GetObject("LDAP://" & dn)
    if err.number <> 0 then
        set parent = GetObject("LDAP://" & parentDn)
        set ou = parent.Create("OrganizationalUnit", cn)
        ou.SetInfo
    end if
    on error goto 0

    set CreateOu = ou

end function

function RetrieveUsers()

    dim rootDse, defaultNamingContext, ldapQuery, ldap, conn, rs

    set rootDse = GetObject("LDAP://RootDSE")
    defaultNamingContext = rootDse.Get("defaultNamingContext")
    ldapQuery = "(&(objectCategory=person)(objectClass=user)(mailNickname=*)(homeMdb=*)(mail=*))"
    ldap = "<LDAP://" & defaultNamingContext & ">;" & ldapQuery & ";adspath;subtree"

    set conn = CreateObject("ADODB.Connection")
    conn.Provider = "ADsDSOObject"    
    conn.Open "Active Directory Provider"
    set RetrieveUsers = conn.Execute(ldap)

end function

function CreateContact(ou, user, forwardingDomain)

    dim displayName, displayNameSuffix, mailNickname, mailNicknameSuffix, mail, forwardingAddress, contactCn, contactDn, contact, name

    displayNameSuffix = " (External Forward)"
    mailNicknameSuffix = "ExternalForward"

    displayName = user.Get("displayName")
    mailNickname = user.Get("mailNickname")
    mail = user.Get("mail")
    name = user.Get("name")

    forwardingAddress = Split(mail, "@")(0) & "@" & forwardingDomain
    contactCn = "CN=" & name
    contactCn = Replace(contactCn, ",", "\,")
    contactDn = contactCn & "," & ou.Get("distinguishedName")
    
    on error resume next
    set contact = GetObject("LDAP://" & contactDn)
    if err.number <> 0 then
        set contact = ou.Create("Contact", contactCn)
        contact.Put "mailNickname", mailNickname & mailNicknameSuffix
        contact.Put "displayName", displayName & displayNameSuffix
        contact.Put "mail", forwardingAddress
        contact.Put "targetAddress", "SMTP:" & forwardingAddress
        contact.Put "proxyAddresses", "SMTP:" & forwardingAddress
        contact.Put "extensionAttribute1", mailNickname
        contact.Put "msExchHideFromAddressLists", True
        contact.SetInfo
    end if
    on error goto 0

end function

'********************************************************************************
' Main Executor
'********************************************************************************

dim contactsOuDn, contactsOu, users

if forwardingDomain <> "example.onmicrosoft.com" then
    contactsOuDn = BuildContactsOuDn(contactsOuName)
    set contactsOu = CreateOu(contactsOuDn)

    set users = RetrieveUsers()
    while not users.EOF
        set user = GetObject(users.Fields(0).Value)
        CreateContact contactsOu, user, forwardingDomain
        users.MoveNext
    wend

    msgbox "Contacts Created Successfully", 0, "New-Exchange2003ContactForwards"
else
    msgbox "ERROR: Modify this script with a text editor and set the forwarding domain located at the top.  Once you have done this, rerun the script.", 0, "New-Exchange2003ContactForwards"
end if
